
#IFDEF __STORY_DEBUG__
	Print __Alisha_._Project & " DevKit " & __Alisha_._Version_Pretty & " Core / Gfx Manip / Buffer Stretch"
	SimpleSleep ( )
#ENDIF

Include2 ( ,  Core/Code/Gfx Manip/Gfx Manip, .bas )

Declare Sub Gfx_Buffer_Stretch ( ByRef Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr )

Declare Sub Gfx_Buffer_Stretch_Aspect ( ByRef Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr, Aspect_Correction As String = "height" )

Sub Gfx_Buffer_Stretch ( ByRef Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr )

	Dim As Long Source_X, Source_Y, Dest_X, Dest_Y

	Dim As FB.Image Ptr Intermediary

	Intermediary = ImageCreate ( Source -> Width, Dest -> Height, RGBA ( 0, 0, 0, 0 ), 32 )

	For Dest_Y = 0 To Dest -> Height - 1 Step 1

		Source_Y = ( Dest_Y * Source -> Height ) \ Dest -> Height

		Put Intermediary, ( 0, Dest_Y ), Source, ( 0, Source_Y ) - Step ( Source -> Width - 1, 0 ), PSet

	Next Dest_Y

	For Dest_X = 0 To Dest -> Width - 1 Step 1

		Source_X = ( Dest_X * Source -> Width ) \ Dest -> Width

		Put Dest, ( Dest_X, 0 ), Intermediary, ( Source_X, 0 ) - Step ( 0, Intermediary -> Height - 1 ), PSet

	Next Dest_X

	Intermediary = ImageDestroy2 ( Intermediary )

End Sub

Sub Gfx_Buffer_Stretch_Aspect ( ByRef Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr, Aspect_Correction As String = "height" )

	Dim As Integer Dest_X = 0, Dest_Y = 0, Source_X = 0, Source_Y = 0

	Dim As FB.Image Ptr Intermediary

	Select Case LCase ( Aspect_Correction )

	Case "height", "h"

		If Dest -> Width / Dest -> Height > Source -> Width / Source -> Height Then

			Intermediary = ImageCreate ( Dest -> Height * Source -> Width / Source -> Height, Dest -> Height, RGBA ( 0, 0, 0, 0 ) )

			Dest = ImageDestroy2 ( Dest )

			Dest = ImageCreate ( Intermediary -> Width, Intermediary -> Height, RGBA ( 0, 0, 0, 0 ) )

			Intermediary = ImageDestroy2 ( Intermediary )

		End If

	Case "width", "w"

		If Dest -> Width / Dest -> Height < Source -> Width / Source -> Height Then

			Intermediary = ImageCreate ( Dest -> Height * Source -> Width / Source -> Height, Dest -> Width, RGBA ( 0, 0, 0, 0 ) )

			Dest = ImageDestroy2 ( Dest )

			Dest = ImageCreate ( Intermediary -> Width, Intermediary -> Height, RGBA ( 0, 0, 0, 0 ) )

			Intermediary = ImageDestroy2 ( Intermediary )

		End If

	End Select

	Gfx_Buffer_Stretch ( Source, Dest )

End Sub
